function commonSubmitArgs = getCommonSubmitArgs(cluster, numWorkers)
% Get any additional submit arguments for the Slurm sbatch command
% that are common to both independent and communicating jobs.

% Copyright 2016-2019 The MathWorks, Inc.

% wiki: https://wiki.hpc.tulane.edu/trac/wiki/cypress

commonSubmitArgs = '';

% Number of cores/node
ppn = validatedPropValue(cluster, 'ProcsPerNode', 'double');
if ppn>0
    % Don't request more cores/node than workers
    ppn = min(numWorkers,ppn);
    commonSubmitArgs = sprintf('%s --ntasks-per-node=%d',commonSubmitArgs,ppn);
end
commonSubmitArgs = sprintf('%s --ntasks-per-core=1',commonSubmitArgs);


%% REQUIRED

%% OPTIONAL

% AccountName
an = validatedPropValue(cluster, 'AccountName', 'char');
if ~isempty(an)
    commonSubmitArgs = [commonSubmitArgs ' -A ' an];
end

% Partition / Check for GPU
% ngpus = validatedPropValue(cluster, 'GpusPerNode', 'double');
% if ngpus>0
%    qn = '';
% else
%    qn = validatedPropValue(cluster, 'QueueName', 'char');
% end
% if ~isempty(qn)
%    commonSubmitArgs = [commonSubmitArgs ' -p ' qn];
% end

% QueueName
qn = validatedPropValue(cluster, 'QueueName', 'char');
if ~isempty(qn)
	commonSubmitArgs = [commonSubmitArgs ' -p ' qn];
end

% Quality of Service
qos = validatedPropValue(cluster, 'QoS', 'char');
if ~isempty(qos)
    commonSubmitArgs = [commonSubmitArgs ' --qos=' qos];
end

% Walltime
wt = validatedPropValue(cluster, 'WallTime', 'char');
if ~isempty(wt)
    commonSubmitArgs = [commonSubmitArgs ' -t ' wt];
end

% Physical Memory used by a single core
mu = validatedPropValue(cluster, 'MemUsage', 'char');
if ~isempty(mu)
    commonSubmitArgs = [commonSubmitArgs ' --mem-per-cpu=' mu];
end

% Email notification
ea = validatedPropValue(cluster, 'EmailAddress', 'char');
if ~isempty(ea)
    commonSubmitArgs = [commonSubmitArgs ' --mail-type=ALL --mail-user=' ea];
end

% Catch-all
asa = validatedPropValue(cluster, 'AdditionalSubmitArgs', 'char');
if ~isempty(asa)
    commonSubmitArgs = [commonSubmitArgs ' ' asa];
end

commonSubmitArgs = strtrim(commonSubmitArgs);
